Plua2Help                         ?v?v                HelpLuaP         hlpD   nhlpI  NhlpW    _G: a global variable (not a function) that holds the global environment (that is, _G._G = _G). Lua itself does not use this variable; changing its value does not affect any environment. (Use setfenv to change environments.) _OS_NAME: a string with the OS name. _OS_VERSION: a string with the PalmOS version number. _PLUA_VERSION: a string with the Plua version number. _VERSION: a global variable (not a function) that holds a string containing the current interpreter version. The current content of this string is "Lua 5.0.3". assert(v[,message]): issues an error when the value of its argument v is nil or false; otherwise, returns this value. message is an error message; when absent, it defaults to "assertion failed!" bin.md5(string): returns in a 16 byte binary string the MD5 digest of the string argument. bin.pack(format,table): packs the elements of a table into a binary string, and the returns this string. The binary data format is specificed by the string argument format, in which each letter refers to a different encoding: b=8 bits signed integer; B=8 bits unsigned integer; w=big endian 16 bits signed integer; W=big endian 16 bits unsigned integer; l=big endian 32 bits signed integer; L=big endian 32 bits unsigned integer; F=big endian 32 bits float; D=big endian 64 bits double; S=variable length string, ended with ASCII null. bin.unpack(format,string): unpacks a binary string encoded with bin.pack and returns a table with the decoded elements. bit.andb(n1,n2): returns a bitwise AND between integers n1 and n2. bit.notb(n): returns a bitwise NOT of integer n. bit.orb(n1,n2): returns a bitwise OR between integers n1 and n2. bit.xorb(n1 n2): returns a bitwise XOR between integers n1 and n2. buffer.free(id): frees the saved buffer. Returns nothing. buffer.get(x,y,dx,dy): saves in a buffer the pixels delimited by a rectangle at x,y, extending dx,dy pixels. Returns a number identifying the saved buffer. buffer.new(dx,dy): creates an blank buffer extending dx,dy pixels. Returns a number identifying the new buffer. buffer.put(id,x,y[,mode]): draws a saved buffer at coordinates x,y. The optional mode parameter affects how pixels are transfered to screen (0=paint, 1=erase, 2=mask, 3=invert, 4=overlay, 5=paint inverse). Returns nothing. buffer.read(filename): reads a buffer from file filename. Returns a number identifying the new buffer, its width and its height. In case of error, nil is returned. buffer.use([id]): sets a selected buffer for drawing. If the argument is missing, the screen is selected for drawing. Returns nothing. buffer.write(filename[,id]): writes buffer identified by id into file filename. If id is not specified the current screen is written. Returns the resulting file size or nil in case of error. collectgarbage([limit]): sets the garbage-collection threshold to the given limit (in Kbytes) and checks it against the byte counter. If the new threshold is smaller than the byte counter, then Lua immediately runs the garbage collector. If limit is absent, it defaults to zero (thus forcing a garbage-collection cycle). coroutine.create(f): creates a new coroutine, with body f. f must be a Lua function. Returns this new coroutine, an object with type "thread". coroutine.resume(co,val1,...): starts or continues the execution of coroutine co. The first time you resume a coroutine, it starts running its body. The arguments val1, ... go as the arguments to the body function. If the coroutine has yielded, resume restarts it; the arguments val1, ... go as the results from the yield. If the coroutine runs without any errors, resume returns true plus any values passed to yield (if the coroutine yields) or any values returned by the body function (if the coroutine terminates). If there is any error, resume returns false plus the error message. coroutine.status(co): returns the status of coroutine co, as a string: "running", if the coroutine is running (that is, it called status); "suspended", if the coroutine is suspended in a call to yield, or if it has not started running yet; and "dead" if the coroutine has finished its body function, or if it has stopped with an error. coroutine.wrap(f): creates a new coroutine, with body f. f must be a Lua function. Returns a function that resumes the coroutine each time it is called. Any arguments passed to the function behave as the extra arguments to resume. Returns the same values returned by resume, except the first boolean. In case of error, propagates the error. coroutine.yield(val1,...): suspends the execution of the calling coroutine. The coroutine cannot be running neither a C function, nor a metamethod, nor an iterator. Any arguments to yield go as extra results to resume. debug.debug(): enters an interactive mode with the user, running each string that the user enters. Using simple commands and other debug facilities, the user can inspect global and local variables, change their values, evaluate expressions, and so on. A line containing only the word cont finishes this function, so that the caller continues its execution. Note that commands for debug.debug are not lexically nested with any function, so they have no direct access to local variables. debug.gethook(): returns the current hook settings, as three values: the current hook function, the current hook mask, and the current hook count (as set by the debug.sethook function). debug.getinfo(function[,what]): this function returns a table with information about a function. You can give the function directly, or you can give a number as the value of function, which means the function running at level function of the call stack: Level 0 is the current function (getinfo itself); level 1 is the function that called getinfo; and so on. If function is a number larger than the number of active functions, then getinfo returns nil. The returned table contains all the fields returned by lua_getinfo, with the string what describing which fields to fill in. The default for what is to get all information available. If present, the option `f adds a field named func with the function itself. For instance, the expression debug.getinfo(1,"n").name returns the name of the current function, if a reasonable name can be found, and debug.getinfo(print) returns a table with all available information about the print function. debug.getlocal(level,local): this function returns the name and the value of the local variable with index local of the function at level level of the stack. (The first parameter or local variable has index 1, and so on, until the last active local variable.) The function returns nil if there is no local variable with the given index, and raises an error when called with a level out of range. (You can call debug.getinfo to check whether the level is valid.) debug.getupvalue(func,up): this function returns the name and the value of the upvalue with index up of the function func. The function returns nil if there is no upvalue with the given index. debug.sethook(hook,mask[,count]): sets the given function as a hook. The string mask and the number count describe when the hook will be called. The string mask may have the following characters, with the given meaning: if "c" the hook is called every time Lua calls a function; if "r" the hook is called every time Lua returns from a function; if "l" the hook is called every time Lua enters a new line of code. With a count different from zero, the hook is called after every count instructions. When called without arguments, the debug.sethook function turns off the hook. When the hook is called, its first parameter is always a string describing the event that triggered its call: "call", "return" (or "tail return"), "line", and "count". Moreover, for line events, it also gets as its second parameter the new line number. Inside a hook, you can call getinfo with level 2 to get more information about the running function (level 0 is the getinfo function, and level 1 is the hook function), unless the event is "tail return". In this case, Lua is only simulating the return, and a call to getinfo will return invalid data. debug.setlocal(level,local,value): this function assigns the value value to the local variable with index local of the function at level level of the stack. The function returns nil if there is no local variable with the given index, and raises an error when called with a level out of range. (You can call getinfo to check whether the level is valid.) debug.setupvalue(func,up,value): this function assigns the value value to the upvalue with index up of the function func. The function returns nil if there is no upvalue with the given index. debug.traceback([message]): returns a string with a traceback of the call stack. An optional message string is appended at the beginning of the traceback. This function is typically used with xpcall to produce better error messages. dofile(filename): opens the named file and executes its contents as a Lua chunk. When called without arguments, dofile executes the contents of the standard input (stdin). Returns any value returned by the chunk. In case of errors, dofile propagates the error to its caller (that is, it does not run in protected mode). error(message[,level]): terminates the last protected function called and returns message as the error message. Function error never returns. The level argument specifies where the error message points the error. With level 1 (the default), the error position is where the error function was called. Level 2 points the error to where the function that called error was called; and so on. f:close(): closes file. f:closerec(): closes the current open record of (already open) database f. Returns true if success or nil if an error occurred. f:createrec(size): creates a new record with given size in (already open) database f. The record is added at the end of the database. The created record is NOT automatically opened, so it is necessary to call openrec() to open the just created record before using it. Returns the index of the new record or nil if an error ocurred. f:deleterec(i): deletes the record with index i from (already open) database f. The record can not be open when it is deleted. Returns true if success or nil if an error occurred. f:flush(): saves any written data to file. f:getdbcat(n): returns the name of category n (where 0 <= n <= 15) from already open database f. f:getreccat(i): returns the category number for record index i from already open database f. f:getrecid(i): returns the unique ID of record index i from already open database f. f:lines(): returns an iterator function that, each time it is called, returns a new line from the file. f:openrec(i): opens the record with index i from an already open database f. If i is negative, the database AppInfo record is opened. Returns the size of the record or nil if an error occurred. f:read(format1,...): reads the file file, according to the given formats, which specify what to read. For each format, the function returns a string (or a number) with the characters read, or nil if it cannot read data with the specified format. When called without formats, it uses a default format that reads the entire next line.The available formats are: "*n" reads a number, this is the only format that returns a number instead of a string; "*a" reads the whole file, starting at the current position. On end of file, it returns the empty string; "*l" reads the next line (skipping the end of line), returning nil on end of file. This is the default format; number reads a string with up to that number of characters, returning nil on end of file. If number is zero, it reads nothing and returns an empty string, or nil on end of file.  f:readdir(): reads a directory entry. Returns the entry name and type (4=directory, 8=regular file). f:removerec(i): removes the record with index i from (already open) database f. The record can not be open when it is removed. Returns true if success or nil if an error occurred. f:resizerec(i,size): resizes the record with index i from (already open) database f to the specified size. If the record beeing resized is the currently open record, it is closed, resized and then reopened. Returns true if success or nil if an error occurred. f:seek([whence][,offset]): sets and gets the file position, measured from the beginning of the file, to the position given by offset plus a base specified by the string whence, as follows: "set" uses position 0 (beginning of the file); "cur" uses current position; "end" uses end of file. In case of success, function seek returns the final file position, measured in bytes from the beginning of the file. If this function fails, it returns nil, plus a string describing the error. The default value for whence is "cur", and for offset is 0. Therefore, the call file:seek() returns the current file position, without changing it; the call file:seek("set") sets the position to the beginning of the file (and returns 0); and the call file:seek("end") sets the position to the end of the file, and returns its size. f:setdbcat(n,cat): sets the name of category n (where 0 <= n <= 15) to "cat" on already open database f. Returns the category name just set. f:setreccat(i,n): sets the category number to n for record index i on already open database f. Returns the category number just set. f:write(value1,...): writes the value of each of its arguments to the filehandle file. The arguments must be strings or numbers. To write other values, use tostring or string.format before write. gcinfo(): returns two results: the number of Kbytes of dynamic memory that Lua is using and the current garbage collector threshold (also in Kbytes). getfenv(f): returns the current environment in use by the function. f can be a Lua function or a number, which specifies the function at that stack level: Level 1 is the function calling getfenv. If the given function is not a Lua function, or if f is 0, getfenv returns the global environment. The default for f is 1. If the environment has a "__fenv" field, returns the associated value, instead of the environment. getmetatable(object): if the object does not have a metatable, returns nil. Otherwise, if the object's metatable has a "__metatable" field, returns the associated value. Otherwise, returns the metatable of the given object. gui.alert(text[,f]): if f is true, opens an error dialog with the specified text. If f is false or not present, opens an information dialog. The user must press the Ok button to close the dialog. Returns nothing. gui.button(text[,bmpId[,filename]]): creates a button with given text in the current cursor position. The cursor is positioned to the right of the component. If the optional bmpId is passed and the PalmOS version supports graphic controls, a graphic button with the given bitmap resource ID is created instead. If an optional filename is passed, the bitmap will be searched on this file only. Returns the ID of the component or nil if it could not be created. gui.checkbox(text): creates a pushbutton with given text in the current cursor position. The cursor is positioned to the right of the component. Returns the ID of the component or nil if it could not be created. gui.confirm(text): opens a confirmation dialog with specified text. The user must press either the Yes or the No button to close the dialog. Returns true if Yes was pressed or false if No was pressed. gui.control(table): creates a label, button, pushbutton, repeating button, selector trigger, slider, field, list or popup, with custom attributes defined in the table parameter. Returns the ID of the component or nil if it could not be created. gui.destroy(): destroys all UI components currently in the screen. Returns nothing. gui.dialog(x,y,dx,dy,title): pops up an empty dialog at position x,y with dimensions dx,dy. Controls can be created inside the dialog. The dialog must be closed with gui.destroy. gui.event([n]): blocks until an event is generated. Events can be a hard button press, a pen event, a UI control selection or whether there is I/O pending. The first returned value is always the event type: penDown, penUp, penMove, keyDown, ctlSelect, ctlRepeat, popSelect, lstSelect, menuSelect, ioPending, sampleStop, appStop or nilEvent. The ioPending event is a efficient way for a program to wait for I/O without polling. The appStop event is sent when the user quits the application. The only way to exit a running application is to catch this event end quit the event loop. If the optional n parameter is passed, gui.event() will wait at most n millisecons for an event. If no event happens, it will return nilEvent. gui.field(lines,cols,max[,text[,e,u]]): creates a text field with given number of lines and columns in the current cursor position. The field will accpet at most max chars. The field is optionally initialized with the specified text. The optional parameter "e" and "u" are values indicating if the field is editable and underlined, respectively. A nil value means false, and not nil value means true. If these parameters are passed, the text parameter must also be passed. The cursor is positioned below the component. Returns the ID of the component or nil if it could not be created. For fields with more than 1 line, a scroll bar is automatically placed to the right of the field if the user enters more text than the number of lines can display. gui.fieldattr(id,e,u): sets the attributes of an existing field identified by the given ID. The next two parameters are the same as in pfield(). Returns nothing. gui.getstate(id): returns a number with the state of the component identified by the given ID. For pushbuttons and checkboxes, the number is 1 if selected, 0 if not selected. For lists and popups, the number is the index of the selected item. For fiels, two numbers are returned: the start and ending position of the selected text. gui.gettext(id): returns a string with the text of the component identified by the given ID. For labels, buttons, pushbuttons, repeating buttons and checkboxes, the text is the label of the component. For field, the the text is its current contents. For list, the text is the current selected element. gui.gsi(): creates a Graffiti State Indicator in the current cursor position. Works only in full screen mode, and only on PalmOS 3.5 or greater. Returns nothing. gui.input([text[,initial]]): opens an input dialog with an optional text as title. A second optional parameter defines the initial value of the input. The user can enter up to 255 characters of input. The user must press either the Ok or the Cancel button to close the dialog. Returns a string with the input entered if Ok was pressed, or nil if Cancel was pressed. gui.inserttext(id,text): inserts a string text in the field identified by the given ID. Returns nothing. gui.label(text): creates a label with given text in the current cursor position. The cursor is positioned to the right of the component. Returns the ID of the component or nil if it could not be created. gui.list(lines,cols,t[,sel]): creates a list with given number of lines and columns in the current cursor position. The list is filled with the elements of table t. Optionally the selected element is set to index sel. The cursor is positioned to the right of the component. Returns the ID of the component or nil if it could not be created. gui.main([n]): loops forever calling gui.event() until an appStop event is generated. Returns nothing. The optional parameter n is passed to gui.event(), if present. gui.menu(t): defines the menu items. Currently there is one fixed menu item that is always available: "About Plua". It is possible to define additional items by passing a table with strings to pmenu(). If a string starts with a letter followed by a colon, the letter is used as the item's shortcut. gui.nl(): positions the cursor at (x,y), where x is the leftmost position and y is below the "tallest" component of the current "line". Returns nothing. gui.pbutton(text[,g[,bmpId[,filename]]]): creates a pushbutton with given text in the current cursor position. Pushbutons can be optionally placed in a given group number g. The cursor is positioned to the right of the component. If the optional bmpId is passed and the PalmOS version supports graphic controls, a graphic button with the given bitmap resource ID is created instead. If an optional filename is passed, the bitmap will be searched on this file only. Returns the ID of the component or nil if it could not be created. gui.popup(t[,sel]): creates a popup list in the current cursor position. The list is filled with the elements of table t. The size is automatically adjusted. Optionally the selected element is set to index sel. The cursor is positioned to the right of the component. Returns the ID of the component or nil if it could not be created. gui.rbutton(text[,bmpId[,filename]]): creates a repeating button with given text in the current cursor position. The cursor is positioned to the right of the component. If the optional bmpId is passed and the PalmOS version supports graphic controls, a graphic button with the given bitmap resource ID is created instead. If an optional filename is passed, the bitmap will be searched on this file only. Returns the ID of the component or nil if it could not be created. gui.selectcolor(text,c): opens the PalmOS color selection dialog. Text is the dialog title, and c is the initial color shown in the dialog. Works only in full screen mode, and only on PalmOS 3.5 or greater. Returns a number with the selected color if Ok was pressed, or nil if Cancel was pressed. gui.selectdate([text[,y,m,d]]): opens the PalmOS day selection dialog. Text is an optional title, and y/m/d are the year, month and day initially shown by the dialog. Returns three numbers with the selected year, month and day, in this order, or nil if Cancel was pressed. gui.selector(text[,bmpId[,filename]]): creates a selector trigger with given text in the current cursor position. The cursor is positioned to the right of the component. If the optional bmpId is passed and the PalmOS version supports graphic controls, a graphic button with the given bitmap resource ID is created instead. If an optional filename is passed, the bitmap will be searched on this file only. Returns the ID of the component or nil if it could not be created. gui.selecttime([text[,h,m]]): opens the PalmOS time selection dialog. Text is an optional title, and h and m are the hour and minute initially shown by the dialog. Returns two numbers with the selected hour and minute, in this order, or nil if Cancel was pressed. gui.setfocus(id): sets the focus to the field identified by the given ID. Works only with text fields. Returns nothing. gui.sethandler(id,f): sets up an event handler for an system event or UI control. The function will be automatically called inside gui.event() whenever an event is generated. The second parameter is a lua function to be used as the event handler. If the first parameter is the ID of a UI control, like a button, the function will be called whenever the control is selected. If the first parameter is a system event constant (nilEvent, keyEvent, penUp, penDown, penMove, menuSelect, ioPending or sampleStop) the function will be called whenever that event is generated. gui.setlist(id,list): sets the text of the component identified by the given ID. Works with lists and popups. The list argument must be a table. Returns nothing. gui.setstate(id,n1[,n2]): sets the state (or index for lists and popups) of the component identified by the given ID to n1. Works with pushbuttons, checkboxes lists and popups. Returns nothing. If the component is a field, if only n1 is passed, sets the insertion point of the field. If n2 is also passed, selects a portion of the field text (from n1 to n2). Returns nothing. gui.settext(id,text): sets the text of the component identified by the given ID. Works with buttons, pushbuttons, repeating buttons, checkboxes, labels and fields. For labels, the text is changed only if the new length is not greater than the current length. For lists, the text argument must be a table. Returns nothing. gui.slider(width,range[,value]): creates a slider control with the specified width in pixels. The slider values go from 0 to range-1. The optional value parameter is the initial slider value. The cursor is positioned to the right of the component. Returns the ID of the component or nil if it could not be created. gui.tab([n]): advances the cursor 8 pixels to the right. It is useful when separating UI components on the same line. If n is specified the cursor is advanced 8*n pixels. Returns nothing. gui.title([text]): sets the title of the current form. Works only in full-screen mode. If the parameter is omited, the title is erased. io.close([f]): equivalent to f:close. Without a file, closes the default output file. io.flush(): equivalent to file:flush over the default output file. io.input([f]): when called with a file name, it opens the named file (in text mode), and sets its handle as the default input file. When called with a file handle, it simply sets that file handle as the default input file. When called without parameters, it returns the current default input file. In case of errors this function raises the error, instead of returning an error code. io.lines([filename]): opens the given file name in read mode and returns an iterator function that, each time it is called, returns a new line from the file. The call io.lines() (without a file name) is equivalent to io.input():lines(), that is, it iterates over the lines of the default input file. io.open(filename[,mode]): this function opens a file, in the mode specified in the string mode. It returns a new file handle, or, in case of errors, nil plus an error message. The mode string can be "r" for read mode (the default); "w" for write mode; "a" for append mode; "r+" for update mode, all previous data is preserved; "w+" for update mode, all previous data is erased; "a+" append update mode, previous data is preserved, writing is only allowed at the end of file.  The mode string may also have a b at the end, which is needed in some systems to open the file in binary mode. io.output([f]): similar to io.input, but operates over the default output file. io.read(format1,...): equivalent to io.input():read. io.tmpfile(): returns a handle for a temporary file. This file is open in update mode and it is automatically removed when the program ends. io.type(obj): checks whether obj is a valid file handle. Returns the string "file" if obj is an open file handle, "closed file" if obj is a closed file handle, and nil if obj is not a file handle. io.write(value1,...): equivalent to io.output():write. ipairs(t): returns an iterator function, the table t, and 0, so that the construction  for i,v in ipairs(t) do ... end  will iterate over the pairs (1,t[1]), (2,t[2]), ..., up to the first integer key with a nil value in the table. loadfile(filename): loads a file as a Lua chunk (without running it). If there are no errors, returns the compiled chunk as a function; otherwise, returns nil plus the error message. The environment of the returned function is the global environment. loadlib(libname,funcname): links the program with the dynamic C library libname. Inside this library, looks for a function funcname and returns this function as a C function. libname must be the name of the C library built with libkit. loadstring(string[,chunkname]): loads a string as a Lua chunk (without running it). If there are no errors, returns the compiled chunk as a function; otherwise, returns nil plus the error message. The environment of the returned function is the global environment. The optional parameter chunkname is the name to be used in error messages and debug information. To load and run a given string, use the idiom: assert(loadstring(s))() math.abs(n): returns the absolute value of n. math.acos(n): returns the angle (in degrees) of cosine n. math.asin(n): returns the angle (in degrees) of sine n. math.atan(n): returns the angle (in degrees) of tangent n. math.atan2(n1,n2): returns the angle (in degrees) corresponding to tangent n1/n2. math.ceil(n): returns n rounded to the ceiling. math.cos(n): returns the cosine of n (n in degrees). math.deg(n): returns n converted to degrees. math.exp(n): returns e ^ n. math.floor(n): returns n rounded to the floor. math.frexp(n): converts n to a normalized number and an exponent (in powers of 2), returning these two numbers. math.ldexp(n1,n2): returns n1 * 2 ^ n2. math.log(n): returns the natural logarithm of n. math.log10(n): returns the decimal logarithm of n. math.max(n1,n2,...): returns the maximum of a sequence of numbers. math.min(n1,n2,...): returns the minumum of a sequence of numbers. math.mod(n1,n2): returns n1 modulo n2. math.pow(n1,n2): returns n1 ^ n2. math.rad(n): returns n converted to radians. math.random([n1[,n2]]): returns a random number. If no arguments are passed, the number is between 0 and 1. If only one argument is passed, the number is between 1 and n1. If two arguments are passed, the number is between n1 and n2. math.randomseed(n): initializes the random number generator with the seed n. math.sin(n): returns the sine of n (n in degrees). math.sqrt(n): returns the square root of n. math.tan(n): returns the tangent of n (n in degrees). next(table[,index]): allows a program to traverse all fields of a table. Its first argument is a table and its second argument is an index in this table. next returns the next index of the table and the value associated with the index. When called with nil as its second argument, next returns the first index of the table and its associated value. When called with the last index, or with nil in an empty table, next returns nil. If the second argument is absent, then it is interpreted as nil. Lua has no declaration of fields; There is no difference between a field not present in a table or a field with value nil. Therefore, next only considers fields with non-nil values. The order in which the indices are enumerated is not specified, even for numeric indices. (To traverse a table in numeric order, use a numerical for or the ipairs function.) The behavior of next is undefined if, during the traversal, you assign any value to a non-existent field in the table. os.clock(): returns an approximation of the amount of CPU time used by the program, in seconds. os.copy(s): copies the string s to the clipboard. Returns nothing. os.date([format[,time]]): returns a string or a table containing date and time, formatted according to the given string format. If the time argument is present, this is the time to be formatted (see the os.time function for a description of this value). Otherwise, date formats the current time. If format starts with `!, then the date is formatted in Coordinated Universal Time. After that optional character, if format is *t, then date returns a table with the following fields: year (four digits), month (1--12), day (1--31), hour (0--23), min (0--59), sec (0--61), wday (weekday, Sunday is 1), yday (day of the year), and isdst (daylight saving flag, a boolean). If format is not *t, then date returns the date as a string, formatted according to the same rules as the C function strftime. When called without arguments, date returns a reasonable date and time representation that depends on the host system and on the current locale (that is, os.date() is equivalent to os.date("%c")). os.exit([code]): calls the C function exit, with an optional code, to terminate the host program. The default value for code is the success code. os.getenv(varname): returns the value of the process environment variable varname, or nil if the variable is not defined. os.getprefs(creator,id): returns a string with the preferecences specified by creator and id, or nil if it does not exist. os.listdb(creator,type[,suffix]): returns a table with all databases matching the specified type and creator, and optional suffix. Type and creator are either a 4 character string or an empty string to accept anything. os.listdir(dirname[,suffix]): returns a table with the file names in a VFS directory. If the optional parameter is specified only files with that suffix are returned. os.mem(): returns used memory and total memory, both in KB. os.mkdir(dirname): creates a VFS directory. Returns true if success or nil if an error ocurred. os.paste(): returns a string with the contents of the clipboard. os.remove(filename): deletes the file with the given name. If this function fails, it returns nil, plus a string describing the error. os.rename(oldname,newname): renames file named oldname to newname. If this function fails, it returns nil, plus a string describing the error. os.setprefs(creator,id,prefs): sets the preferecences specified by creator and id to the given string prefs. Returns nothing. os.sleep(s): psleep(s): pauses the execution for s seconds (s can be a decimal number). Returns nothing. os.time([table]): returns the current time when called without arguments, or a time representing the date and time specified by the given table. This table must have fields year, month, and day, and may have fields hour, min, sec, and isdst (for a description of these fields, see the os.date function). The returned value is a number, whose meaning depends on your system. In Posix, Windows, and some other systems, this number counts the number of seconds since some given start time (the "epoch"). In other systems, the meaning is not specified, and the number returned by time can be used only as an argument to date and difftime. os.tmpname(): returns a string with a file name that can be used for a temporary file. The file must be explicitly opened before its use and removed when no longer needed. This function is equivalent to the tmpnam C function, and many people (and even some compilers!) advise against its use, because between the time you call this function and the time you open the file, it is possible for another process to create a file with the same name. pairs(t): returns the next function and the table t (plus a nil), so that the construction  for k,v in pairs(t) do ... end  will iterate over all key-value pairs of table t. pcall(f,arg1,arg2,...): calls function f with the given arguments in protected mode. That means that any error inside f is not propagated; instead, pcall catches the error and returns a status code. Its first result is the status code (a boolean), which is true if the call succeeds without errors. In such case, pcall also returns all results from the call, after this first result. In case of any error, pcall returns false plus the error message. print(e1,e2,...): receives any number of arguments, and prints their values in stdout, using the tostring function to convert them to strings. This function is not intended for formatted output, but only as a quick way to show a value, typically for debugging. For formatted output, use format. rawequal(v1,v2): checks whether v1 is equal to v2, without invoking any metamethod. Returns a boolean. rawget(table,index): gets the real value of table[index], without invoking any metamethod. table must be a table; index is any value different from nil. rawset(table,index,value): sets the real value of table[index] to value, without invoking any metamethod. table must be a table, index is any value different from nil, and value is any Lua value. require(packagename): loads the given package. The function starts by looking into the table _LOADED to determine whether packagename is already loaded. If it is, then require returns the value that the package returned when it was first loaded. Otherwise, it searches for a file to load. The function stops the search as soon as it can load a file, and then it runs the file. After that, it associates, in table _LOADED, the package name with the value that the package returned, and returns that value. If the package returns nil (or no value), require converts this value to true. If the package returns false, require also returns false. However, as the mark in table _LOADED is false, any new attempt to reload the file will happen as if the package was not loaded (that is, the package will be loaded again). If there is any error loading or running the file, or if it cannot find any file, then require signals an error. While running a file, require defines the global variable _REQUIREDNAME with the package name. The package being loaded always runs within the global environment. resource.close(r): closes the resource identified by number r. The number r is returned by the resource.open() function. Returns nothing. resource.draw(r[,mode]): draws the bitmap resource identified by the number r in the current cursor position. The cursor is advanced to the right of the bitmap. The optional mode parameter affects how pixels are transfered to screen (0=paint, 1=erase, 2=mask, 3=invert, 4=overlay, 5=paint inverse). The number r is returned by the resource.open() function. If the resource is not a bitmap, this function has no efect. Returns nothing. resource.get(r[,start[,end]]): returns a string with the contents of the resource identified by number r. You can optionally specify just a substring of the resource, with the start and end parameters. The number r is returned by the resource.open() function. Returns a string with the resource. resource.list(type,filename): returns a table with the resource ID's of the given type present on a resource database. resource.md5(r): returns in a 16 byte binary string the MD5 digest of the resource identified by number r. The number r is returned by the resource.open() function. resource.open(type,id[,filename]): opens the resource with specified type (4 character string) and id. The resource is searched in all open databases or, if the optional filename parameter is passed, only in the database named "filename". Returns a number identifying the resource. resource.size(r): returns the size of the resource identified by number r. If the resource is a bitmap, two additional numbers are returned: the width and the height of the bitmap. The number r is returned by the resource.open() function. screen.box(x,y,dx,dy[,c]): draws a filled rectangle at x,y, extending dx,dy pixels, using the fg color or the optional c color. screen.circle(x,y,rx,ry[,c]): draws an ellipse centered at x,y, with rx,ry as x,y radius, using the fg color or the optional c color. Use rx=ry for a circle. screen.clear([c]): erases the screen with the background color or with the optional c color, and moves the cursor to 0,0. Returns nothing. screen.clip(x,y,dx,dy): sets the clipping region to the rectangle at x,y, extending dx,dy pixels. If no parameter is passed the clipping region is reset. Returns nothing. screen.color(fg[,bg]): sets the foreground color (fg) and optionally the background color (bg). Returns nothing. screen.disc(x,y,rx,ry[,c]): draws a filled ellipse centered at x,y, with rx,ry as x,y radius, using the fg color or the optional c color. Use rx=ry for a filled circle. screen.fill(x,y,[,c]): starts a flood fill in the pixel located at x,y with current color or the optional c color. The filling stops at pixels with a different color than the initial pixel. Returns nothing. screen.font(f): sets the text font to number f. Returns two numbers with the "average" width of a character and the height of a character, both in pixels. Note that PalmOS fonts are not fixed-width fonts, so if the returned width is used in calculations, you get just an approximation. screen.getpixel(x,y): return a number with the color of pixel at position x,y. screen.heading(r): sets the turtle heading to r radians. 0 points to the right, math.pi/2 points up, and so on. Returns nothing. screen.jump(d): moves the cursor d pixels from the current cursor position, following the current heading. Returns nothing. screen.line(x1,y1,x2,y2[,c]): draws a line from x1,y1 to x2,y2 using the fg color or the optional c color. screen.lineto(x,y[,c]): draws a line from current position to x,y using the fg color or the optional c color. screen.mode(): returns four values: screen width, screen height, screen depth and true or false indicating if the screen supports color. In interactive mode the screen height is half of the full-screen mode. screen.moveto(x[,y]): moves the screen cursor to the x,y position. If y is omited the current y position is used. screen.pos(): returns two numbers with the current x,y cursor position. screen.rect(x,y,dx,dy[,c]): draws a rectangle at x,y, extending dx,dy pixels, using the fg color or the optional c color. screen.rgb(r,g,b): returns the color equivalent to the (Red,Green,Blue) components. screen.setpixel(x,y[,c]): draws a pixel at position x,y using the fg color or the optional c color. screen.textsize(text): returns the width and height of the text string in pixels. screen.turn(r): turns the turtle r radians. r can be positive or negative and it is added to the current heading. Returns nothing. screen.walk(d): draws a line from the current cursor position, with extent d pixels and following the current heading. The cursor is positioned at the end of the line. Returns nothing. setfenv(f,table): sets the current environment to be used by the given function. f can be a Lua function or a number, which specifies the function at that stack level: Level 1 is the function calling setfenv. As a special case, when f is 0 setfenv changes the global environment of the running thread. If the original environment has a "__fenv" field, setfenv raises an error. setmetatable(table,metatable): sets the metatable for the given table. (You cannot change the metatable of a userdata from Lua.) If metatable is nil, removes the metatable of the given table. If the original metatable has a "__metatable" field, raises an error. sound.beep(n): plays the system sound identified by the number n. Returns nothing. sound.midi(filename[,volume]): plays a Format 0 Standard MIDI file. The MIDI file can be a resource or a database record. If volume (0-64) is not specified, the default system Game volume is used. This function is blocking, that is, it will return only after the MIDI is played to the end. If the user taps on the screen during the play, however, the play interruped. Returns true if the MIDI file was valid and played to the end, or nil and and an error message if the MIDI file was invalid or the play was interrupted. A common error is trying to play the more common Format 1 MIDI, which is not supported by PalmOS. sound.play(filename[,volume]): plays sampled sound stored in a WAV file. If volume (0-64) is not specified, the default system Game volume is used. Returns the duration of the sampled sound in seconds, or nil in case of error. After the sample is played a sampleStop event is generated. sound.stop(): stops playing sampled sound. Returns nothing. sound.tone(freq,len[,volume]): plays a tone with frequency freq (in Hz), duration len (in millisenconds), and optionally volume (0-64). Returns nothing. sprite.add(index,table): adds one sprite to the sprite engine. At most 32 simultaneous sprites are supported. The first argument is the sprite index, between 1 and 32. This number is also the sprite priority. Lower numbered sprites are draw "below" higher numbered sprites. The second argument is the sprite definition table. Sprites can be added and removed between calls to sprite.update(). Returns true on success, or nil plus an error message. sprite.finish(): finishes the sprite engine. Calling any other sprite method after finish is an error. Returns true on success, or nil plus an error message. sprite.init(buffer[,x,y]): initializes the sprite engine. It must be called before any other sprite method. It accepts as argument a buffer handle created by buffer.new or buffer.read. This buffer will be used as the static background during the animation. Two additional optional parameters are the horizontal and vertical coordinates of the background top left corner on the screen (the background does not need to be the same size of the screen). Returns true on success, or nil plus an error message. sprite.remove(index): removes one sprite from the sprite engine. The single argument is the sprite index. Sprites can be added and removed between calls to sprite.update(). Returns true on success, or nil plus an error message. sprite.update(): draws a complete frame to the screen, with background and all active sprites. The collision callback functions (if any) are also called inside the update method. To perform smooth animation, you will have to intercalate calls to gui.event (with the timeout parameter) and sprite.update. string.byte(s[,i]): returns the internal numerical code of the i-th character of s, or nil if the index is out of range. If i is absent, then it is assumed to be 1. i may be negative. Note that numerical codes are not necessarily portable across platforms. string.char(i1,i2,...): receives 0 or more integers. Returns a string with length equal to the number of arguments, in which each character has the internal numerical code equal to its correspondent argument. Note that numerical codes are not necessarily portable across platforms. string.dump(function): returns a binary representation of the given function, so that a later loadstring on that string returns a copy of the function. function must be a Lua function without upvalues. string.find(s,pattern[,init[,plain]]): looks for the first match of pattern in the string s. If it finds one, then find returns the indices of s where this occurrence starts and ends; otherwise, it returns nil. If the pattern specifies captures (see string.gsub), the captured strings are returned as extra results. A third, optional numerical argument init specifies where to start the search; it may be negative and its default value is 1. A value of true as a fourth, optional argument plain turns off the pattern matching facilities, so the function does a plain "find substring" operation, with no characters in pattern being considered "magic". Note that if plain is given, then init must be given too. string.format(formatstring,e1,e2,...): returns a formatted version of its variable number of arguments following the description given in its first argument (which must be a string). The format string follows the same rules as the printf family of standard C functions. The only differences are that the options/modifiers *, l, L, n, p, and h are not supported, and there is an extra option, q. The q option formats a string in a form suitable to be safely read back by the Lua interpreter: The string is written between double quotes, and all double quotes, newlines, and backslashes in the string are correctly escaped when written. string.gfind(s,pat): returns an iterator function that, each time it is called, returns the next captures from pattern pat over string s. If pat specifies no captures, then the whole match is produced in each call. string.gsub(s,pat,repl[,n]): returns a copy of s in which all occurrences of the pattern pat have been replaced by a replacement string specified by repl. gsub also returns, as a second value, the total number of substitutions made. If repl is a string, then its value is used for replacement. Any sequence in repl of the form %n, with n between 1 and 9, stands for the value of the n-th captured substring. If repl is a function, then this function is called every time a match occurs, with all captured substrings passed as arguments, in order; if the pattern specifies no captures, then the whole match is passed as a sole argument. If the value returned by this function is a string, then it is used as the replacement string; otherwise, the replacement string is the empty string. The optional last parameter n limits the maximum number of substitutions to occur. For instance, when n is 1 only the first occurrence of pat is replaced. string.len(s): receives a string and returns its length. The empty string "" has length 0. Embedded zeros are counted, so "a\000b\000c" has length 5. string.lower(s): receives a string and returns a copy of that string with all uppercase letters changed to lowercase. All other characters are left unchanged. The definition of what is an uppercase letter depends on the current locale. string.rep(s,n): returns a string that is the concatenation of n copies of the string s. string.sub(s,i[,j]): returns the substring of s that starts at i and continues until j; i and j may be negative. If j is absent, then it is assumed to be equal to -1 (which is the same as the string length). In particular, the call string.sub(s,1,j) returns a prefix of s with length j, and string.sub(s, -i) returns a suffix of s with length i. string.upper(s): receives a string and returns a copy of that string with all lowercase letters changed to uppercase. All other characters are left unchanged. The definition of what is a lowercase letter depends on the current locale. table.concat(table[,sep[,i[,j]]]): returns table[i]..sep..table[i+1] ... sep..table[j]. The default value for sep is the empty string, the default for i is 1, and the default for j is the size of the table. If i is greater than j, returns the empty string. table.foreach(table,f): executes the given f over all elements of table. For each element, f is called with the index and respective value as arguments. If f returns a non-nil value, then the loop is broken, and this value is returned as the final value of foreach. table.foreachi(table,f): executes the given f over the numerical indices of table. For each index, f is called with the index and respective value as arguments. Indices are visited in sequential order, from 1 to n, where n is the size of the table. If f returns a non-nil value, then the loop is broken and this value is returned as the result of foreachi. table.getn(table): returns the size of a table, when seen as a list. If the table has an n field with a numeric value, this value is the size of the table. Otherwise, if there was a previous call to table.setn over this table, the respective value is returned. Otherwise, the size is one less the first integer index with a nil value. table.insert(table,[pos,]value): inserts element value at position pos in table, shifting up other elements to open space, if necessary. The default value for pos is n+1, where n is the size of the table, so that a call table.insert(t,x) inserts x at the end of table t. This function also updates the size of the table by calling table.setn(table, n+1). table.remove(table[,pos]): removes from table the element at position pos, shifting down other elements to close the space, if necessary. Returns the value of the removed element. The default value for pos is n, where n is the size of the table, so that a call table.remove(t) removes the last element of table t. This function also updates the size of the table by calling table.setn(table, n-1). table.setn(table,n): updates the size of a table. If the table has a field "n" with a numerical value, that value is changed to the given n. Otherwise, it updates an internal state so that subsequent calls to table.getn(table) return n. table.sort(table[,comp]): sorts table elements in a given order, in-place, from table[1] to table[n], where n is the size of the table. If comp is given, then it must be a function that receives two table elements, and returns true when the first is less than the second (so that not comp(a[i+1],a[i]) will be true after the sort). If comp is not given, then the standard Lua operator < is used instead. The sort algorithm is not stable, that is, elements considered equal by the given order may have their relative positions changed by the sort. tonumber(e): tries to convert its argument to a number in base 10. If the argument is already a number or a string convertible to a number, then tonumber returns that number; otherwise, it returns nil. The number may have a decimal part, as well as an optional exponent part. tostring(e): receives an argument of any type and converts it to a string in a reasonable format. For complete control of how numbers are converted, use format. If the metatable of e has a "__tostring" field, tostring calls the corresponding value with e as argument, and uses the result of the call as its result. type(v): returns the type of its only argument, coded as a string. The possible results of this function are "nil" (a string, not the value nil), "number", "string", "boolean, "table", "function", "thread", and "userdata". unpack(list): returns all elements from the given list. This function is equivalent to  return list[1], list[2], ..., list[n]  except that the above code can be written only for a fixed n. The number n is the size of the list, as defined for the table.getn function. xpcall(f,err): this function is similar to pcall, except that you can set a new error handler. xpcall calls function f in protected mode, using err as the error handler. Any error inside f is not propagated; instead, xpcall catches the error, calls the err function with the original error object, and returns a status code. Its first result is the status code (a boolean), which is true if the call succeeds without errors. In such case, xpcall also returns all results from the call, after this first result. In case of any error, xpcall returns false plus the result from err.         < &r / 6 >0 GH R [ d4 lu u     	 
 
   1'a3GAO^o@}!!"#%x%&'\((;(()N)!*x(-2.(>.J/Q3\3h4 p4w5z778:;q<:=/=>6A
CDEG G*I$9ICJYLKULT^MeNqP,{QzSQTzUWcXkX[[]6^x_`o `)aM2a;cDd<LfVf^gigqh^zhi}jxkdmmCm}mmnBnrnnno
ooo)p2p^;pDpMpVqbrrrN{rrrvwwQ{1{|=|}~:~v~-!)4L:@FOJV]ett'Okƕtѕߖ9)9HT`nz6~Lʠ֠>ꢷ
{#.o9/GSao{ƻѼ޽^				+	6b	C	PS	[@	fc	ow	x̲	}͑	Μ_G _OS_NAME _OS_VERSION _PLUA_VERSION _VERSION assert bin.md5 bin.pack bin.unpack bit.andb bit.notb bit.orb bit.xorb buffer.free buffer.get buffer.new buffer.put buffer.read buffer.use buffer.write collectgarbage coroutine.create coroutine.resume coroutine.status coroutine.wrap coroutine.yield debug.debug debug.gethook debug.getinfo debug.getlocal debug.getupvalue debug.sethook debug.setlocal debug.setupvalue debug.traceback dofile error f:close f:closerec f:createrec f:deleterec f:flush f:getdbcat f:getreccat f:getrecid f:lines f:openrec f:read f:readdir f:removerec f:resizerec f:seek f:setdbcat f:setreccat f:write gcinfo getfenv getmetatable gui.alert gui.button gui.checkbox gui.confirm gui.control gui.destroy gui.dialog gui.event gui.field gui.fieldattr gui.getstate gui.gettext gui.gsi gui.input gui.inserttext gui.label gui.list gui.main gui.menu gui.nl gui.pbutton gui.popup gui.rbutton gui.selectcolor gui.selectdate gui.selector gui.selecttime gui.setfocus gui.sethandler gui.setlist gui.setstate gui.settext gui.slider gui.tab gui.title io.close io.flush io.input io.lines io.open io.output io.read io.tmpfile io.type io.write ipairs loadfile loadlib loadstring math.abs math.acos math.asin math.atan math.atan2 math.ceil math.cos math.deg math.exp math.floor math.frexp math.ldexp math.log math.log10 math.max math.min math.mod math.pow math.rad math.random math.randomseed math.sin math.sqrt math.tan next os.clock os.copy os.date os.exit os.getenv os.getprefs os.listdb os.listdir os.mem os.mkdir os.paste os.remove os.rename os.setprefs os.sleep os.time os.tmpname pairs pcall print rawequal rawget rawset require resource.close resource.draw resource.get resource.list resource.md5 resource.open resource.size screen.box screen.circle screen.clear screen.clip screen.color screen.disc screen.fill screen.font screen.getpixel screen.heading screen.jump screen.line screen.lineto screen.mode screen.moveto screen.pos screen.rect screen.rgb screen.setpixel screen.textsize screen.turn screen.walk setfenv setmetatable sound.beep sound.midi sound.play sound.stop sound.tone sprite.add sprite.finish sprite.init sprite.remove sprite.update string.byte string.char string.dump string.find string.format string.gfind string.gsub string.len string.lower string.rep string.sub string.upper table.concat table.foreach table.foreachi table.getn table.insert table.remove table.setn table.sort tonumber tostring type unpack xpcall 